import pandas

def load_sparse_depth(dataset_name, scene_name, frame_len, frame_num, resolution_suffix):
    """_summary_

    Args:
        scene_name (str): name of the scene ex. horns
        frame_num (int): frame id
        resolution_suffix (int): down sample num

    Returns:
        _type_: _description_
    """
    if dataset_name == "nerf_llff_data":
        depth_path = f'estimated_depths/{dataset_name}/DE0{frame_len}/{scene_name}/estimated_depths_down{resolution_suffix}/{frame_num:04}.csv'
        depth_data = pandas.read_csv(depth_path)
        return depth_data  
    elif dataset_name == "DTU":
        scene_name = int(scene_name[4:])
        depth_path = f'estimated_depths/{dataset_name}/DE0{frame_len}/{scene_name:05}/estimated_depths/{frame_num:04}.csv'
        depth_data = pandas.read_csv(depth_path)
        return depth_data  
    elif dataset_name == "RealEstate10K":
        depth_path = f'estimated_depths/{dataset_name}/DE0{frame_len}/{scene_name}/estimated_depths/{frame_num:04}.csv'
        depth_data = pandas.read_csv(depth_path)
        return depth_data
    