#!/bin/bash

# Define the values of k
# k_values=(8 21 30 31 34 38 40 41 45 55 63 82 103 110 114)
# k_values=(103 12)
k_values=(21 31 34 38 40 41 45 55 63 82 103 114)
expname="exp8"

# Iterate through the k values
for k in "${k_values[@]}"
do
    echo "Training with k=$k"
    python train.py --config "configs/dtu0.txt" --expname "$expname" --basedir "log_dtu_rescale/scan$k" --datadir "data/rs_dtu_4/DTU/scan$k"
done
cp configs/dtu0.txt log_dtu_rescale/"scan$k"/"$expname"/config.txt
cd extra
python read_metrics.py --expname "$expname"
python read_metrics.py --expname "$expname" --masked
cd ..