![ALT](/docs/verse.jpg)
OrganDetr is a project that provides state-of-the-art DETR-based [1] detection algorithms on 3D CT datasets. It supports a number of backbones like FPN [2], ResNet [3], RetinaNet [4], SwinFPN [5] and Swin Transformer [6], as well as different matching mechanisms like one-to-one matching and one-to-many matching, including our proposed Dense Query Matching (DQM). 
# Model Overview
![ALT](/docs/framework.png)
We proposed a novel multi-scale attention (MSA) module with a dual attention mechanism that aims to provide the most relevant features for DETRs. Additionally, we proposed DQM, which enhances both recall scores and training efficiency via adding a new set of ground-truth samples in matching. Please refer to our paper for more details. 

# Installation

Create a new virtual environment using, for example, anaconda:

    conda create -n organdetr python=3.8 -y
    conda activate organdetr

Install torch and torchvision (we tested torch 1.13.1 and 2.0.0) with the correct CUDA version:
    e.g.,

    pip install torch==1.13.1+cu117 torchvision==0.14.1+cu117 --extra-index-url https://download.pytorch.org/whl/cu117

Install all dependencies:

    pip install -e .

Set environment variable for the directory that contains the preprocessed data:


    ORGANDETR_DATA=dataset
for

    dataset
    └── amos_256_256_128_CT

# Data Preparation
1. Download dataset  (e.g., [AMOS22](https://zenodo.org/record/7155725#.Y0OOCOxBztM))
2. Update path in `config/preprocessing_amos.yaml`
3. run `python scripts/prepare_dataset_amos.py`

# Training
Run 

    python scripts/train.py --config config_name

# Testing
Run

    python scripts/test.py --run run_name --gpu 0

# References
[1] Carion, Nicolas, et al. "End-to-end object detection with transformers." European conference on computer vision. Cham: Springer International Publishing, 2020.  
[2] Lin, Tsung-Yi, et al. "Feature pyramid networks for object detection." Proceedings of the IEEE conference on computer vision and pattern recognition. 2017.  
[3] He, Kaiming, et al. "Deep residual learning for image recognition." Proceedings of the IEEE conference on computer vision and pattern recognition. 2016.  
[4] Lin, Tsung-Yi, et al. "Focal loss for dense object detection." Proceedings of the IEEE international conference on computer vision. 2017.  
[5] Wittmann, Bastian, et al. "Swinfpn: Leveraging vision transformers for 3d organs-at-risk detection." Medical Imaging with Deep Learning. 2022.  
[6] Hatamizadeh, Ali, et al. "Swin unetr: Swin transformers for semantic segmentation of brain tumors in mri images." International MICCAI Brainlesion Workshop. Cham: Springer International Publishing, 2021.