import os
from setuptools import setup, find_packages

def resolve_requirements(file):
    requirements = []
    with open(file) as f:
        req = f.read().splitlines()
        for r in req:
            if r.startswith("-r"):
                requirements += resolve_requirements(
                    os.path.join(os.path.dirname(file), r.split(" ")[1]))
            else:
                requirements.append(r)
    return requirements

requirements = resolve_requirements(
    os.path.join(os.path.dirname(__file__), 'requirements.txt')
)

setup(
    name='organ_detr',
    version='0.1',
    description='3D organ detection based on a Deformable DETR.',
    author='TODO',
    author_email='TODO',
    url='TODO',
    packages=find_packages(),
    entry_points={},
    install_requires=requirements,
    python_requires=">=3.8"
)
