import numpy as np
import matplotlib.pyplot as plt
import pickle


def et_dbo_agent(dim, adjacent_matrix, M, v, Gamma, T_agent, W0_agent, K, topology, N_data):
    x = np.zeros((v, M, K + 1))
    x_hat = np.zeros((v, M, K + 1))
    x_new = np.zeros((M * v, K + 1))

    for i in np.arange(v):
        x_new[np.arange(M * i, M * (i+1)), 0] = W0_agent[:, i]

    e = np.zeros((v, M, K + 1))
    tk_agent = np.zeros((v, K + 1), dtype=int)
    tk_agent[:, 0] = np.zeros((v, 1)).ravel()
    for i_agent in np.arange(v):
        x[i_agent, :, 0] = W0_agent[:, i_agent]
        x_hat[i_agent, :, 0] = W0_agent[:, i_agent]

    h = 10000 * np.ones((v, 1, K + 1))

    for k in np.arange(K):
        neigh_influence = np.zeros((M, v))
        for i_agent in np.arange(v):
            c_ET = 0.1
            beta_ET = 0.995
            e[i_agent, :, k] = x_hat[i_agent, :, k] - x[i_agent, :, k]
            h[i_agent, :, k] = np.dot(e[i_agent, :, k].T, e[i_agent, :, k]) - c_ET * (beta_ET**(k+1))

            if h[i_agent, :, k] > 0:
                tk_agent[i_agent, k] = k
                for j in np.arange(v):
                    neigh_influence[:, i_agent] = neigh_influence[:, i_agent] + adjacent_matrix[i_agent, j] * (x_hat[j, :, tk_agent[i_agent, k]] - x_hat[i_agent, :, tk_agent[i_agent, k]])

                x[i_agent, :, k+1] = x[i_agent, :, k] + Gamma * np.dot(np.linalg.inv(T_agent[i_agent, :, :]), neigh_influence[:, i_agent])
                x_hat[i_agent, :, k+1] = x[i_agent, :, k+1]

            else:
                if k == 0:
                    tk_agent[i_agent, k] = 0

                else:
                    tk_agent[i_agent, k] = tk_agent[i_agent, k-1]

                for j in np.arange(v):
                    neigh_influence[:, i_agent] = neigh_influence[:, i_agent] + adjacent_matrix[i_agent, j] * (x_hat[j, :, tk_agent[i_agent, k]] - x_hat[i_agent, :, tk_agent[i_agent, k]])

                x[i_agent, :, k+1] = x[i_agent, :, k] + Gamma * np.dot(np.linalg.inv(T_agent[i_agent, :, :]), neigh_influence[:, i_agent])
                x_hat[i_agent, :, k+1] = x_hat[i_agent, :, k]

            x_new[np.arange(i_agent * M, (i_agent + 1) * M), k+1] = x[i_agent, :, k+1]

    w_agent = x_new
    np.save('w_agent_DBO.npy', w_agent)

    return tk_agent, w_agent, h, e, x, x_hat
