import numpy as np


def algebraic_graph_calculate(v, topology):
    if topology == 'path':
        adjacent_matrix = np.zeros((v, v))
        adjacent_matrix[0, 1] = 1
        adjacent_matrix[v-1, v-2] = 1

        degree_matrix = np.zeros((v, v))
        degree_matrix[0, 0] = 1
        degree_matrix[v-1, v-1] = 1

        for i in np.arange(1, v-1):
            adjacent_matrix[i, i-1] = 1
            adjacent_matrix[i, i+1] = 1
            degree_matrix[i, i] = 2

        laplacian_matrix = degree_matrix - adjacent_matrix

    elif topology == 'ring':
        adjacent_matrix = np.zeros((v, v))
        adjacent_matrix[0, 1] = 1
        adjacent_matrix[0, v-1] = 1
        adjacent_matrix[v-1, v-2] = 1
        adjacent_matrix[v-1, 0] = 1

        degree_matrix = np.zeros((v, v))
        degree_matrix[0, 0] = 2
        degree_matrix[v-1, v-1] = 2

        for i in np.arange(1, v-1):
            adjacent_matrix[i, i-1] = 1
            adjacent_matrix[i, i+1] = 1
            degree_matrix[i, i] = 2

        laplacian_matrix = degree_matrix - adjacent_matrix

    elif topology == 'random':
        if v == 5:
            adjacent_matrix = np.array([[0, 1, 0, 0, 1],
                                        [1, 0, 1, 0, 1],
                                        [0, 1, 0, 1, 0],
                                        [0, 0, 1, 0, 1],
                                        [1, 1, 0, 1, 0]])

            degree_matrix = np.array([[2, 0, 0, 0, 0],
                                      [0, 3, 0, 0, 0],
                                      [0, 0, 2, 0, 0],
                                      [0, 0, 0, 2, 0],
                                      [0, 0, 0, 0, 3]])
        else:
            print('error')

        laplacian_matrix = degree_matrix - adjacent_matrix

    elif topology == 'fully-connected':
        arr0 = np.identity(v)

        adjacent_matrix = np.ones((v, v)) - arr0
        degree_matrix = (v-1) * arr0

        laplacian_matrix = degree_matrix - adjacent_matrix
    else:
        print('error')

    return adjacent_matrix, degree_matrix, laplacian_matrix
