import numpy as np
import matplotlib.pyplot as plt


def dcl_agent(dim, adjacent_matrix, M, v, Gamma, T_agent, W0_agent, K, topology, N_data):
    x = np.zeros((v, M, K + 1))
    x_new = np.zeros((M * v, K + 1))
    for i in np.arange(v):
        x_new[np.arange(M * i, M * (i+1)), 0] = W0_agent[:, i]

    for i_agent in np.arange(v):
        x[i_agent, :, 0] = W0_agent[:, i_agent]

    for k in np.arange(K):
        neigh_influence = np.zeros((M*dim, v))
        for i_agent in np.arange(v):
            for j in np.arange(v):
                neigh_influence[:, i_agent] = neigh_influence[:, i_agent] + adjacent_matrix[i_agent, j] * (x[j, :, k] - x[i_agent, :, k])

            x[i_agent, :, k+1] = x[i_agent, :, k] + Gamma * np.dot(np.linalg.inv(T_agent[i_agent, :, :]), neigh_influence[:, i_agent])
            x_new[np.arange(i_agent * M, (i_agent + 1) * M), k+1] = x[i_agent, :, k+1]

    w_agent = x_new
    np.save('w_agent_DCL.npy', w_agent)

    return w_agent
