import numpy as np
from sklearn import svm
from sklearn.linear_model import LogisticRegression


def sort_with_index(arr):
    sorted_indexes = np.argsort(arr)
    sorted_arr = arr[sorted_indexes]
    return sorted_arr, sorted_indexes


def blkdiag(*arrs):
    shapes = np.array([np.array(arr.shape) for arr in arrs])
    out_shape = np.sum(shapes, axis=0)
    out = np.zeros(out_shape)
    row, col = 0, 0
    for arr in arrs:
        r, c = arr.shape
        out[row:row+r, col:col+c] = arr
        row += r
        col += c

    return out


def levy(xxx):
    # d = len(xxx)
    d = xxx.size
    xxx = xxx.reshape(1, d)
    w = np.zeros((1, d))
    for ii in np.arange(d):
        w[0, ii] = 1 + (xxx[0, ii] - 1) / 4

    term1 = np.sin(np.pi * w[0, 0]) ** 2
    term3 = ((w[0, d-1] - 1) ** 2) * (1 + (np.sin(2 * np.pi * w[0, d-1]) ** 2))
    total_sum = 0
    for ii in np.arange(d-1):
        wi = w[0, ii]
        new = ((wi - 1) ** 2) * (1 + 10*((np.sin(np.pi * wi + 1))**2))
        total_sum = total_sum + new

    yyy = term1 + total_sum + term3
    return yyy


def ackley(xxx):
    d = xxx.size
    xxx = xxx.reshape(1, d)
    c = 2 * np.pi
    b = 0.2
    a = 20

    sum1 = 0
    sum2 = 0
    for ii in np.arange(d):
        xxxi = xxx[0, ii]
        sum1 = sum1 + xxxi ** 2
        sum2 = sum2 + np.cos(c * xxxi)

    term1 = -a * np.exp(-b * np.sqrt(sum1 / d))
    term2 = -np.exp(sum2 / d)
    yyy = term1 + term2 + a + np.exp(1)
    return yyy


def griewank(xxx):
    d = xxx.size
    xxx = xxx.reshape(1, d)
    total_sum = 0
    prod = 1
    for ii in np.arange(d):
        xi = xxx[0, ii]
        total_sum = total_sum + (xi**2)/4000
        prod = prod * np.cos(xi/np.sqrt(ii+1))

    y = total_sum - prod + 1
    return y


def initialization_total_ionosphere(N, dim, down, up):
    xxx = np.zeros((N, dim))
    if dim == 1:
        xxx = np.dot(np.random.rand(N, dim), (up-down)) + down
        xxx = np.round(xxx * 100)/100

    if dim > 1:
        for i in np.arange(dim):
            high = up[0, i].reshape(1, 1)
            low = down[0, i].reshape(1, 1)
            print("high.shape: ", high.shape)
            xxx[:, i] = np.dot(np.random.rand(N, 1), (high - low)).ravel() + np.dot(np.ones((N, 1)), low).ravel()
            print(type(xxx))
            xxx[:, i] = np.round(xxx[:, i] * 100)/100

    return xxx


def initialization_total_iris(N, dim, down, up):
    xxx = np.zeros((N, dim))
    if dim == 1:
        xxx = np.random.permutation(10)[:N] + 1

    if dim > 1:
        for i in np.arange(dim):
            if i == 0:
                high = up[0, i].reshape(1, 1)
                low = down[0, i].reshape(1, 1)
                print("high.shape: ", high.shape)
                xxx[:, i] = np.dot(np.random.rand(N, 1), (high - low)).ravel() + np.dot(np.ones((N, 1)), low).ravel()
                print(type(xxx))
                xxx[:, i] = np.round(xxx[:, i] * 100)/100

            else:
                high = up[0, i].reshape(1, 1)
                low = down[0, i].reshape(1, 1)
                print("high.shape: ", high.shape)
                xxx[:, i] = np.random.permutation([1, 2, 3, 4, 5])[:5]

    return xxx


def fitness_func_ionosphere(traindata, trainlabel, p, i):
    gam = p[0]
    C = p[1]
    clf = svm.SVC(kernel="rbf", C=C, gamma=gam, probability=True)
    clf.fit(traindata, trainlabel)
    out = clf.predict(traindata)
    accuracy = np.size(np.where(out == trainlabel))/np.size(trainlabel)
    error = 1 - accuracy
    return error


def fitness_func_iris(traindata, trainlabel, p, i):
    C = p[0]
    max_iter = p[1]
    lr = LogisticRegression(multi_class='multinomial', solver='lbfgs', C=C, max_iter=max_iter)
    lr.fit(traindata, trainlabel)
    out = lr.predict(traindata)
    accuracy = np.size(np.where(out == trainlabel))/np.size(trainlabel)
    error = 1 - accuracy
    return error


def fitness_func_iris_C(traindata, trainlabel, p, i):
    C = p
    lr = LogisticRegression(multi_class='multinomial', solver='lbfgs', max_iter=100, C=C)
    lr.fit(traindata, trainlabel)
    out = lr.predict(traindata)
    accuracy = np.size(np.where(out == trainlabel))/np.size(trainlabel)
    error = 1 - accuracy
    return error
