import time
import numpy as np
from DBO_helper_funcs import sort_with_index
from algebraic_graph_calculate import algebraic_graph_calculate
from matplotlib import pyplot as plt
from DBO_helper_funcs import fitness_func_iris_C


plt.close('all')
start_time = time.time()


dim = 1
N_data = 5
K = 500
num1 = 100
N_search = num1
# N_search: 100000
renpengfei = 1.025


independent_global_iteration_CTA = 5
max_Iter = 3

topology_list = ["fully-connected"]

for i_topology in topology_list:
    topology = i_topology
    plt.close('all')
    print(topology)
    for iter_global in np.arange(independent_global_iteration_CTA):
        print("iter_global: ", iter_global)
        v = 10
        inf_value = float('inf')

        path1 = 'C:\\PycharmProjects\\pythonProject\\Iris\\overlapping\\fully_connected\\'
        path2 = str(iter_global)
        path3 = '\\'
        path4 = [""] * 12
        path4[0] = 'X1.npy'
        path4[1] = 'X2.npy'
        path4[2] = 'X3.npy'
        path4[3] = 'X4.npy'
        path4[4] = 'X5.npy'
        path4[5] = 'X6.npy'
        path4[6] = 'X7.npy'
        path4[7] = 'X8.npy'
        path4[8] = 'X9.npy'
        path4[9] = 'X10.npy'
        path4[10] = 'testdata.npy'
        path4[11] = 'testlabel.npy'

        path01 = path1 + path2 + path3 + path4[0]
        path02 = path1 + path2 + path3 + path4[1]
        path03 = path1 + path2 + path3 + path4[2]
        path04 = path1 + path2 + path3 + path4[3]
        path05 = path1 + path2 + path3 + path4[4]
        path06 = path1 + path2 + path3 + path4[5]
        path07 = path1 + path2 + path3 + path4[6]
        path08 = path1 + path2 + path3 + path4[7]
        path09 = path1 + path2 + path3 + path4[8]
        path10 = path1 + path2 + path3 + path4[9]
        path11 = path1 + path2 + path3 + path4[10]
        path12 = path1 + path2 + path3 + path4[11]

        X1 = np.load(path01)
        X2 = np.load(path02)
        X3 = np.load(path03)
        X4 = np.load(path04)
        X5 = np.load(path05)
        X6 = np.load(path06)
        X7 = np.load(path07)
        X8 = np.load(path08)
        X9 = np.load(path09)
        X10 = np.load(path10)
        testdata = np.load(path11, allow_pickle=True)
        testlabel = np.load(path12, allow_pickle=True)

        fitness = inf_value * np.ones((N_data, v))
        for i in np.arange(N_data):
            fitness[i, 0] = fitness_func_iris_C(testdata[0], testlabel[0], X1[i], 0)
            fitness[i, 1] = fitness_func_iris_C(testdata[1], testlabel[1], X2[i], 1)
            fitness[i, 2] = fitness_func_iris_C(testdata[2], testlabel[2], X3[i], 2)
            fitness[i, 3] = fitness_func_iris_C(testdata[3], testlabel[3], X4[i], 3)
            fitness[i, 4] = fitness_func_iris_C(testdata[4], testlabel[4], X5[i], 4)
            fitness[i, 5] = fitness_func_iris_C(testdata[5], testlabel[5], X6[i], 5)
            fitness[i, 6] = fitness_func_iris_C(testdata[6], testlabel[6], X7[i], 6)
            fitness[i, 7] = fitness_func_iris_C(testdata[7], testlabel[7], X8[i], 7)
            fitness[i, 8] = fitness_func_iris_C(testdata[8], testlabel[8], X9[i], 8)
            fitness[i, 9] = fitness_func_iris_C(testdata[9], testlabel[9], X10[i], 9)

        x = np.zeros((v, N_data, dim))
        x[0, :, :] = X1.reshape(N_data, dim)
        x[1, :, :] = X2.reshape(N_data, dim)
        x[2, :, :] = X3.reshape(N_data, dim)
        x[3, :, :] = X4.reshape(N_data, dim)
        x[4, :, :] = X5.reshape(N_data, dim)
        x[5, :, :] = X6.reshape(N_data, dim)
        x[6, :, :] = X7.reshape(N_data, dim)
        x[7, :, :] = X8.reshape(N_data, dim)
        x[8, :, :] = X9.reshape(N_data, dim)
        x[9, :, :] = X10.reshape(N_data, dim)
        X_train0 = x
        # --------------------------------------------------------------------------------------------------------------
        M = 200
        m = 1

        print("X_train: ", X_train0.shape)
        X1_train = X_train0[0, :, :]
        # X1_train: (1, 5, 2)
        X2_train = X_train0[1, :, :]
        X3_train = X_train0[2, :, :]
        X4_train = X_train0[3, :, :]
        X5_train = X_train0[4, :, :]
        X6_train = X_train0[5, :, :]
        X7_train = X_train0[6, :, :]
        X8_train = X_train0[7, :, :]
        X9_train = X_train0[8, :, :]
        X10_train = X_train0[9, :, :]
        X_train = np.hstack([X1_train, X2_train, X3_train, X4_train, X5_train, X6_train, X7_train, X8_train, X9_train, X10_train])
        X_train_exhibition = np.hstack([X1_train, X2_train, X3_train, X4_train, X5_train, X6_train, X7_train, X8_train, X9_train, X10_train])
        Y_train = fitness
        print("Y_train: ", Y_train.shape)
        adjacent_matrix, degree_matrix, laplacian_matrix = algebraic_graph_calculate(v, topology)
        # --------------------------------------------------------------------------------------------------------------
        C_matrix_CTA = np.zeros(v)
        max_degree = np.max(np.max(degree_matrix))
        d_max = np.zeros((v, v))
        CC = np.zeros((v, v))
        for i in np.arange(v):
            for j in np.arange(i+1, v):
                if adjacent_matrix[i, j] == 1:
                    print(type(degree_matrix[i, i]))
                    print("degree_matrix[i, i].size: ", degree_matrix[i, i].size)
                    print("degree_matrix[i, i]: ", degree_matrix[i, i])
                    print("degree_matrix[j, j]: ", degree_matrix[j, j])
                    d_max[i, j] = np.max(np.array([degree_matrix[i, i], degree_matrix[j, j]]))
                    print("d_max[i, j]: ", d_max[i, j])
                    d_max[j, i] = d_max[i, j]
                    CC[i, j] = 1/d_max[i, j]
                    CC[j, i] = CC[i, j]

            CC[i, i] = 1 - np.sum(CC[i, :])
        # --------------------------------------------------------------------------------------------------------------

        sigma = np.ones((1, v))
        s = np.load('s.npy')
        print("s.shape: ", s.shape)
        b = np.load('b.npy')
        print("b.shape: ", b.shape)
        T_agent = np.zeros((v, dim * M, dim * M))
        W0_agent = np.zeros((dim * M, v))
        MCRs_total = np.zeros((max_Iter, v))
        best_parameter = np.zeros((max_Iter, dim * v))
        n_M = np.arange(M)
        for itr in np.arange(max_Iter):
            print("itr: ", itr)
            Phi = np.zeros((v * (N_data + itr), M))
            n_Iter = np.arange(N_data + itr)
            for i in np.arange(v):
                for j in np.arange(N_data + itr):
                    print("X_train.shape: ", X_train.shape)
                    features = np.sqrt(2/M) * np.cos(X_train[j, i] * s.T + b)
                    features = features / np.sqrt(np.dot(features, features.T))
                    Phi[(N_data + itr) * i + j, :] = features
            # ----------------------------------------------------------------------------------------------------------
            SS_block = np.zeros((v, N_data + itr, dim * M))
            for i in np.arange(v):
                SS_block[i] = Phi[n_Iter + i * (N_data + itr)]

            Sigma = sigma[0, 0]
            SS = SS_block[0]
            for i in np.arange(1, v):
                Sigma = np.block([[Sigma, np.zeros((i, 1))],
                                  [np.zeros((1, i)), sigma[0, i]]])
                SS = np.block([[SS, np.zeros((i * (N_data + itr), dim * M))],
                               [np.zeros((N_data + itr, i * dim * M)), SS_block[i]]])

            SS_inv = np.linalg.inv(np.dot(SS.T, SS) + np.kron(Sigma, np.identity(m * dim * M)))
            # #---------------------------------------------------------------------------------------------------------
            eigenvalues_L = np.linalg.eigvals(laplacian_matrix)
            lambdaN = np.max(eigenvalues_L)
            print('lambdaN: ', lambdaN)

            sorted_eigenvalues_L, sorted_indexes_eigenvalues_L = sort_with_index(eigenvalues_L)
            lambda2 = sorted_eigenvalues_L[1]

            eigenvalues_T_agent = np.zeros((m * dim * M, v))
            Lambda = np.zeros((v, m * dim * M))
            max_eigenvalues_T_agent = np.zeros((1, v))
            min_eigenvalues_T_agent = np.zeros((1, v))

            for i in np.arange(v):
                T_agent[i] = np.dot(Phi[n_Iter + i * (N_data+itr)].T, Phi[n_Iter + i * (N_data+itr)]) + sigma[0, 0] * np.identity(m * dim * M)
                eigenvalues_T_agent[:, i] = np.linalg.eigvals(T_agent[i])
                max_eigenvalues_T_agent[0, i] = eigenvalues_T_agent[:, i].max()
                min_eigenvalues_T_agent[0, i] = eigenvalues_T_agent[:, i].min()

            Xi = np.max(max_eigenvalues_T_agent)
            print("Xi: ", Xi)
            print("\n")
            xi = np.min(min_eigenvalues_T_agent)
            print("xi: ", xi)
            print("\n")
            epsilon = 1
            Gamma = 0.625 * 1/lambdaN
            print("Gamma: ", Gamma)
            for i in np.arange(v):
                W0_agent[:, i] = np.dot(np.dot(np.linalg.inv(T_agent[i]), Phi[n_Iter+i*(N_data+itr)].T), Y_train[:, i])

            # CTA ------------------------------------------------------------------------------------------------------
            u_CTA = 0.6
            d = np.zeros((v, N_data + itr))
            for i in np.arange(v):
                d[i, :] = Y_train[:, i].T

            # Distributed CTA LMS Algorithm
            W_CTA = W0_agent
            W_CTA = W_CTA.reshape(dim * M, v)
            fai_CTA = np.zeros((dim * M, v))
            C_CTA = CC
            h_CTA = np.zeros((v * (N_data + itr), dim * M))

            for i in np.arange(v):
                a_CTA = np.arange((N_data + itr)*i, (N_data + itr)*(i + 1))
                h_CTA[a_CTA, :] = Phi[a_CTA, :]

            for T_CTA in np.arange(K + 1):
                for i in np.arange(v):
                    fai_CTA[:, i] = np.dot(W_CTA, C_CTA[:, i])

                for i in np.arange(v):
                    a_CTA = np.arange((N_data + itr) * i, (N_data + itr) * (i + 1))
                    W_CTA[:, i] = fai_CTA[:, i] + u_CTA * (np.dot(h_CTA[a_CTA, :].T, (d[i, :].T - np.dot(h_CTA[a_CTA, :], fai_CTA[:, i]))) - 2 / (
                                    N_data + itr) * fai_CTA[:, i])

            X_search = np.load("xx.npy")
            features_search = np.zeros((N_search, M))
            Y_search = np.zeros((N_search, v))
            for i in np.arange(N_search):
                features_search[i, :] = np.sqrt(2/M) * np.cos(np.dot(X_search[i, :], s.T) + b)
                features_search[i, :] = features_search[i, :] / np.sqrt(np.dot(features_search[i, :].T, features_search[i, :]))

            Y_search = np.dot(features_search, W_CTA)

            Y_pred = np.zeros((N_search, v))
            minimum_Y_pred = np.zeros((1, v))
            pos = np.zeros((1, v), dtype=int)
            X_train_append = np.zeros((1, dim * v))
            Y_train_append = np.zeros((1, v))
            for i in np.arange(v):
                Y_pred[:, i] = Y_search[:, i].ravel()
                sorted_Y_pred, sorted_indexes_Y_pred = sort_with_index(Y_pred[:, i])
                pos[:, i] = sorted_indexes_Y_pred[0]
                X_train_append[:, np.arange(i*dim, (i+1)*dim)] = X_search[pos[:, i], :]
                Y_train_append[:, i] = fitness_func_iris_C(testdata[i], testlabel[i], X_train_append[:, np.arange(i*dim, (i+1)*dim)].item(), i)

            X1_train = np.vstack([X1_train, X_train_append[:, np.arange(dim)]])
            X2_train = np.vstack([X2_train, X_train_append[:, np.arange(dim, 2*dim)]])
            X3_train = np.vstack([X3_train, X_train_append[:, np.arange(2*dim, 3*dim)]])
            X4_train = np.vstack([X4_train, X_train_append[:, np.arange(3*dim, 4*dim)]])
            X5_train = np.vstack([X5_train, X_train_append[:, np.arange(4*dim, 5*dim)]])
            X6_train = np.vstack([X6_train, X_train_append[:, np.arange(5*dim, 6*dim)]])
            X7_train = np.vstack([X7_train, X_train_append[:, np.arange(6*dim, 7*dim)]])
            X8_train = np.vstack([X8_train, X_train_append[:, np.arange(7*dim, 8*dim)]])
            X9_train = np.vstack([X9_train, X_train_append[:, np.arange(8*dim, 9*dim)]])
            X10_train = np.vstack([X10_train, X_train_append[:, np.arange(9*dim, 10*dim)]])
            X_train_exhibition = np.vstack([X_train_exhibition, X_train_append])

            MCRs = np.zeros((1, v))
            X_train = np.hstack((X1_train, X2_train, X3_train, X4_train, X5_train, X6_train, X7_train, X8_train, X9_train, X10_train))
            Y_train = np.vstack((Y_train, Y_train_append))

            for i in np.arange(v):
                MCRs[:, i] = fitness_func_iris_C(testdata[i], testlabel[i], X_train_append[:, np.arange(i*dim, (i+1)*dim)].item(), i)
                print("MCR of HO optimized SVM for agent ", i, "is ", MCRs[:, i])

            MCRs_total[itr, :] = MCRs
            best_parameter[itr, :] = X_train_append

        print("Hello!")

        path5 = [""] * 5
        path5[0] = 'tk.npy'
        path5[1] = 'best_parameter_CTA.npy'
        path5[2] = 'MCRs_total_CTA.npy'
        path5[3] = 'X_train_CTA.npy'
        path5[4] = 'Y_train_CTA.npy'

        path6 = path1 + path2 + path3 + path5[0]
        path7 = path1 + path2 + path3 + path5[1]
        path8 = path1 + path2 + path3 + path5[2]
        path9 = path1 + path2 + path3 + path5[3]
        path10 = path1 + path2 + path3 + path5[4]

        np.save(path7, best_parameter)
        np.save(path8, MCRs_total)
        np.save(path9, X_train)
        np.save(path10, Y_train)

# ----------------------------------------------------------------------------------------------------------------------
end_time = time.time()
time_cost = end_time - start_time
print(f"Time taken: {time_cost} seconds")
