import numpy as np
import matplotlib.pyplot as plt
import random

num_datasets = 5
max_Iter = 5
v = 5

path1 = 'C:\\PycharmProjects\\pythonProject\\Levy\\overlapping\\fully_connected\\'
path3 = '\\'
path4 = 'tk.npy'
path = [""] * num_datasets
count = np.zeros(num_datasets)
count_per_trial = np.zeros(num_datasets)

K = 1000
a = np.arange(K + 1)

tk_instants = np.zeros((max_Iter, v, K + 1))

for i in np.arange(num_datasets):
    path2 = str(i)
    path[i] = path1 + path2 + path3 + path4
    tk = np.load(path[i])
    count[i] = 0
    for i_agent in np.arange(v):
        for itr in np.arange(max_Iter):
            for k in a:
                if tk[itr, i_agent, k] == k:
                    tk_instants[itr, i_agent, k] = i_agent + 1
                    count[i] = count[i] + 1

    print("i: ", i)
    count_per_trial[i] = np.sum(count[i]) / (v * max_Iter)
    print("count_per_trial[i]: ", count_per_trial[i])

# ------------------------------------------------------------------------------------------------------------------
# ------------------------------------------------------------------------------------------------------------------
random.seed(28)
random_numbers = []
for _ in range(5):
    random_number = random.randint(0, 4)
    random_numbers.append(random_number)

print(random_numbers)
# random_numbers: [0, 1, 4, 4, 1]

count_tk_instants = np.zeros((v, num_datasets))

for i_agent in np.arange(v):
    for i_datasets in np.arange(num_datasets):
        for k in a:
            if tk[random_numbers[i_datasets], i_agent, k] == k:
                count_tk_instants[i_agent, i_datasets] = count_tk_instants[i_agent, i_datasets] + 1

# ----------------------------------------------------------------------------------------------------------------------
x = [1, 2, 3, 4, 5]
y11 = count_per_trial
y12 = np.array([1000, 1000, 1000, 1000, 1000])

fig, axs = plt.subplots(3, 2, figsize=(10, 12))
axs = axs.flatten()

axs[0].plot(x, y11, marker='s', label='ZGS-ED-DLCB')

axs[0].plot(x, y12, marker='d', label='Baselines')

axs[0].set_xlabel('Trials')
axs[0].set_ylabel('Average Triggering Frequency')
axs[0].set_xticks(range(1, 6))
axs[0].legend()

# ---------------------------------------------------------------------------------------------------
x2 = np.arange(0, 101)
tk_instants = tk_instants[:, :, :100]
y21 = tk_instants[random_numbers[0], 0, :]
indices21 = np.nonzero(y21)[0]
y21 = y21[indices21]

y22 = tk_instants[random_numbers[0], 1, :]
indices22 = np.nonzero(y22)[0]
y22 = y22[indices22]

y23 = tk_instants[random_numbers[0], 2, :]
indices23 = np.nonzero(y23)[0]
y23 = y23[indices23]

y24 = tk_instants[random_numbers[0], 3, :]
indices24 = np.nonzero(y24)[0]
y24 = y24[indices24]

y25 = tk_instants[random_numbers[0], 4, :]
indices25 = np.nonzero(y25)[0]
y25 = y25[indices25]

axs[1].scatter(indices21, y21, label='Agent 1', s=2)
axs[1].scatter(indices22, y22, label='Agent 2', s=2)
axs[1].scatter(indices23, y23, label='Agent 3', s=2)
axs[1].scatter(indices24, y24, label='Agent 4', s=2)
axs[1].scatter(indices25, y25, label='Agent 5', s=2)

axs[1].set_xlabel('ZGS-ED-DLCB: Triggering Instants of Iteration Step 0 in Trial 1')
axs[1].set_ylabel('Agent No.')
axs[1].set_xticks(range(0, 101, 10))
axs[1].set_yticks(range(1, 6))
axs[1].legend(loc='center left', bbox_to_anchor=(0.71, 0.5))
# ---------------------------------------------------------------------------------------------------
x3 = np.arange(0, 101)
tk_instants = tk_instants[:, :, :100]
y31 = tk_instants[random_numbers[1], 0, :]
indices31 = np.nonzero(y31)[0]
y31 = y31[indices31]

y32 = tk_instants[random_numbers[1], 1, :]
indices32 = np.nonzero(y32)[0]
y32 = y32[indices32]

y33 = tk_instants[random_numbers[1], 2, :]
indices33 = np.nonzero(y33)[0]
y33 = y33[indices33]

y34 = tk_instants[random_numbers[1], 3, :]
indices34 = np.nonzero(y34)[0]
y34 = y34[indices34]

y35 = tk_instants[random_numbers[1], 4, :]
indices35 = np.nonzero(y35)[0]
y35 = y35[indices35]

axs[2].scatter(indices31, y31, label='Agent 1', s=2)
axs[2].scatter(indices32, y32, label='Agent 2', s=2)
axs[2].scatter(indices33, y33, label='Agent 3', s=2)
axs[2].scatter(indices34, y34, label='Agent 4', s=2)
axs[2].scatter(indices35, y35, label='Agent 5', s=2)

axs[2].set_xlabel('ZGS-ED-DLCB: Triggering Instants of Iteration Step 1 in Trial 2')
axs[2].set_ylabel('Agent No.')
axs[2].set_xticks(range(0, 101, 10))
axs[2].set_yticks(range(1, 6))
axs[2].legend(loc='center left', bbox_to_anchor=(0.71, 0.5))
# ---------------------------------------------------------------------------------------------------
x4 = np.arange(0, 101)
tk_instants = tk_instants[:, :, :100]
y41 = tk_instants[random_numbers[2], 0, :]
indices41 = np.nonzero(y41)[0]
y41 = y41[indices41]

y42 = tk_instants[random_numbers[2], 1, :]
indices42 = np.nonzero(y42)[0]
y42 = y42[indices42]

y43 = tk_instants[random_numbers[2], 2, :]
indices43 = np.nonzero(y43)[0]
y43 = y43[indices43]

y44 = tk_instants[random_numbers[2], 3, :]
indices44 = np.nonzero(y44)[0]
y44 = y44[indices44]

y45 = tk_instants[random_numbers[2], 4, :]
indices45 = np.nonzero(y45)[0]
y45 = y45[indices45]

axs[3].scatter(indices41, y41, label='Agent 1', s=2)
axs[3].scatter(indices42, y42, label='Agent 2', s=2)
axs[3].scatter(indices43, y43, label='Agent 3', s=2)
axs[3].scatter(indices44, y44, label='Agent 4', s=2)
axs[3].scatter(indices45, y45, label='Agent 5', s=2)

axs[3].set_xlabel('ZGS-ED-DLCB: Triggering Instants of Iteration Step 4 in Trial 3')
axs[3].set_ylabel('Agent No.')
axs[3].set_xticks(range(0, 101, 10))
axs[3].set_yticks(range(1, 6))
axs[3].legend(loc='center left', bbox_to_anchor=(0.71, 0.5))
# ---------------------------------------------------------------------------------------------------
x5 = np.arange(0, 101)
tk_instants = tk_instants[:, :, :100]
y51 = tk_instants[random_numbers[3], 0, :]
indices51 = np.nonzero(y51)[0]
y51 = y51[indices51]

y52 = tk_instants[random_numbers[3], 1, :]
indices52 = np.nonzero(y52)[0]
y52 = y52[indices52]

y53 = tk_instants[random_numbers[3], 2, :]
indices53 = np.nonzero(y53)[0]
y53 = y53[indices53]

y54 = tk_instants[random_numbers[3], 3, :]
indices54 = np.nonzero(y54)[0]
y54 = y54[indices54]

y55 = tk_instants[random_numbers[3], 4, :]
indices55 = np.nonzero(y55)[0]
y55 = y55[indices55]

axs[4].scatter(indices51, y51, label='Agent 1', s=2)
axs[4].scatter(indices52, y52, label='Agent 2', s=2)
axs[4].scatter(indices53, y53, label='Agent 3', s=2)
axs[4].scatter(indices54, y54, label='Agent 4', s=2)
axs[4].scatter(indices55, y55, label='Agent 5', s=2)

axs[4].set_xlabel('ZGS-ED-DLCB: Triggering Instants of Iteration Step 4 in Trial 4')
axs[4].set_ylabel('Agent No.')
axs[4].set_xticks(range(0, 101, 10))
axs[4].set_yticks(range(1, 6))
axs[4].legend(loc='center left', bbox_to_anchor=(0.71, 0.5))
# ---------------------------------------------------------------------------------------------------
x6 = np.arange(0, 101)
tk_instants = tk_instants[:, :, :100]
y61 = tk_instants[random_numbers[4], 0, :]
indices61 = np.nonzero(y61)[0]
y61 = y61[indices61]

y62 = tk_instants[random_numbers[4], 1, :]
indices62 = np.nonzero(y62)[0]
y62 = y62[indices62]

y63 = tk_instants[random_numbers[4], 2, :]
indices63 = np.nonzero(y63)[0]
y63 = y63[indices63]

y64 = tk_instants[random_numbers[4], 3, :]
indices64 = np.nonzero(y64)[0]
y64 = y64[indices64]

y65 = tk_instants[random_numbers[4], 4, :]
indices65 = np.nonzero(y65)[0]
y65 = y65[indices65]

axs[5].scatter(indices61, y61, label='Agent 1', s=2)
axs[5].scatter(indices62, y62, label='Agent 2', s=2)
axs[5].scatter(indices63, y63, label='Agent 3', s=2)
axs[5].scatter(indices64, y64, label='Agent 4', s=2)
axs[5].scatter(indices65, y65, label='Agent 5', s=2)

axs[5].set_xlabel('ZGS-ED-DLCB: Triggering Instants of Iteration Step 2 in Trial 5')
axs[5].set_ylabel('Agent No.')
axs[5].set_xticks(range(0, 101, 10))
axs[5].set_yticks(range(1, 6))
axs[5].legend(loc='center left', bbox_to_anchor=(0.71, 0.5))
# ---------------------------------------------------------------------------------------------------
plt.tight_layout()
plt.savefig('tf_line_charts.pdf', format='pdf')
plt.show()
