static inline pte_t __ptep_get_and_clear(struct mm_struct *mm,
				       unsigned long address, pte_t *ptep)
{
	pte_t pte = __pte(xchg_relaxed(&pte_val(*ptep), 0));

	page_table_check_pte_clear(mm, pte);

	return pte;
}

static inline pte_t ptep_get_and_clear(struct mm_struct *mm,
				unsigned long addr, pte_t *ptep)
{
	contpte_try_unfold(mm, addr, ptep, __ptep_get(ptep));
	return __ptep_get_and_clear(mm, addr, ptep);
}
