static inline void __set_pte(pte_t *ptep, pte_t pte)
{
	WRITE_ONCE(*ptep, pte);

	/*
	 * Only if the new pte is valid and kernel, otherwise TLB maintenance
	 * or update_mmu_cache() have the necessary barriers.
	 */
	if (pte_valid_not_user(pte)) {
		dsb(ishst);
		isb();
	}
}
static inline pte_t __ptep_get(pte_t *ptep)
{
	return READ_ONCE(*ptep);
}
static inline pte_t pte_mknoncont(pte_t pte)
{
	return clear_pte_bit(pte, __pgprot(PTE_CONT));
}

static inline void set_pte(pte_t *ptep, pte_t pte)
{
	/*
	 * We don't have the mm or vaddr so cannot unfold contig entries (since
	 * it requires tlb maintenance). set_pte() is not used in core code, so
	 * this should never even be called. Regardless do our best to service
	 * any call and emit a warning if there is any attempt to set a pte on
	 * top of an existing contig range.
	 */
	pte_t orig_pte = __ptep_get(ptep);

	WARN_ON_ONCE(pte_valid_cont(orig_pte));
	__set_pte(ptep, pte_mknoncont(pte));
}