static inline void __set_pte(pte_t *ptep, pte_t pte)
{
#ifdef CONFIG_KOI
    if (!pte_none(pte)) {
		pte = __pte(pte_val(pte) | PTE_NG);
    }
#endif
#ifdef CONFIG_PTP
	iee_rw_gate(IEE_OP_SET_PTE, ptep, pte);
	dsb(ishst);
	isb();
#else
	WRITE_ONCE(*ptep, pte);

	/*
	 * Only if the new pte is valid and kernel, otherwise TLB maintenance
	 * or update_mmu_cache() have the necessary barriers.
	 */
	if (pte_valid_not_user(pte)) {
		dsb(ishst);
		isb();
	}
#endif
}

static inline void set_pte(pte_t *ptep, pte_t pte)
{
	/*
	 * We don't have the mm or vaddr so cannot unfold contig entries (since
	 * it requires tlb maintenance). set_pte() is not used in core code, so
	 * this should never even be called. Regardless do our best to service
	 * any call and emit a warning if there is any attempt to set a pte on
	 * top of an existing contig range.
	 */
	pte_t orig_pte = __ptep_get(ptep);

	WARN_ON_ONCE(pte_valid_cont(orig_pte));
	__set_pte(ptep, pte_mknoncont(pte));
}
