#ifdef CONFIG_PTP
extern void iee_set_bm_pte(pte_t *ptep, pte_t pte);
extern void iee_set_fixmap_pte_pre_init(pte_t *ptep, pte_t pte);
#endif

#ifdef CONFIG_IEE
extern void set_pte(pte_t *ptep, pte_t pte);
#else
static inline void set_pte(pte_t *ptep, pte_t pte)
{
#ifdef CONFIG_KOI
    if (pte_valid(pte)) {
		pte = __pte(pte_val(pte) | PTE_NG);
    }
#endif
	WRITE_ONCE(*ptep, pte);

	/*
	 * Only if the new pte is valid and kernel, otherwise TLB maintenance
	 * or update_mmu_cache() have the necessary barriers.
	 */
	if (pte_valid_not_user(pte)) {
		dsb(ishst);
		isb();
	}
}
#endif