#define pud_leaf(pud)		(pud_present(pud) && !pud_table(pud))
#define pud_valid(pud)		pte_valid(pud_pte(pud))
#define pud_user(pud)		pte_user(pud_pte(pud))
#define pud_user_exec(pud)	pte_user_exec(pud_pte(pud))

static inline void set_pud(pud_t *pudp, pud_t pud)
{
#ifdef __PAGETABLE_PUD_FOLDED
	if (in_swapper_pgdir(pudp)) {
		set_swapper_pgd((pgd_t *)pudp, __pgd(pud_val(pud)));
		return;
	}
#endif /* __PAGETABLE_PUD_FOLDED */

	WRITE_ONCE(*pudp, pud);

	if (pud_valid(pud)) {
		dsb(ishst);
		isb();
	}
}