static void this_cpu_set_vectors(enum arm64_bp_harden_el1_vectors slot)
{
	const char *v = arm64_get_bp_hardening_vector(slot);

	__this_cpu_write(this_cpu_vector, v);

	/*
	 * When KPTI is in use, the vectors are switched when exiting to
	 * user-space.
	 */
	if (arm64_kernel_unmapped_at_el0())
		return;

#ifdef CONFIG_IEE
    iee_rwx_gate_entry(IEE_WRITE_vbar_el1, v);
#else
	write_sysreg(v, vbar_el1);
#endif
	isb();
}