static inline const struct cred *get_cred_rcu(const struct cred *cred)
{
	struct cred *nonconst_cred = (struct cred *) cred;
	if (!cred)
		return NULL;
	#ifdef CONFIG_CREDP
	if (!iee_set_cred_atomic_op_usage(nonconst_cred,AT_INC_NOT_ZERO))
		return NULL;
	#else
	if (!atomic_inc_not_zero(&nonconst_cred->usage))
		return NULL;
	#endif
	validate_creds(cred);
	#ifdef CONFIG_CREDP
	iee_set_cred_non_rcu(nonconst_cred,0);
	#else
	nonconst_cred->non_rcu = 0;
	#endif
	return cred;
}
