#ifdef CONFIG_HAVE_ALIGNED_STRUCT_PAGE
#define _struct_page_alignment	__aligned(2 * sizeof(unsigned long))
#else
#define _struct_page_alignment
#endif

#ifdef CONFIG_PTP
struct pgtable_page {	/* Page table pages */
	union
	{
		struct list_head lru;
		struct {
			unsigned long _pt_pad_1;	/* compound_head */
			pgtable_t pmd_huge_pte; /* protected by page->ptl */
		};
	};
	unsigned long _pt_pad_2;	/* mapping */
	union {
		struct mm_struct *pt_mm; /* x86 pgds only */
		atomic_t pt_frag_refcount; /* powerpc */
	};
	struct page *page;
#if ALLOC_SPLIT_PTLOCKS
	spinlock_t *ptl;
#else
	spinlock_t ptl;
#endif
};
#endif