static void array_map_free(struct bpf_map *map)
{
	struct bpf_array *array = container_of(map, struct bpf_array, map);

	if (array->map.map_type == BPF_MAP_TYPE_PERCPU_ARRAY)
		bpf_array_free_percpu(array);

	#ifdef CONFIG_HIVE
	if ((array->map.map_flags & BPF_F_MMAPABLE) || array->map.is_aggregated)
		bpf_map_area_free(array_map_vmalloc_addr(array));
	#else
	if (array->map.map_flags & BPF_F_MMAPABLE)
		bpf_map_area_free(array_map_vmalloc_addr(array));
	#endif
	else
		bpf_map_area_free(array);
}
