static int htab_map_gen_lookup(struct bpf_map *map, struct bpf_insn *insn_buf)
{
	struct bpf_insn *insn = insn_buf;
	const int ret = BPF_REG_0;

	BUILD_BUG_ON(!__same_type(&__htab_map_lookup_elem,
		     (void *(*)(struct bpf_map *map, void *key))NULL));
	*insn++ = BPF_EMIT_CALL(BPF_CAST_CALL(__htab_map_lookup_elem));
	*insn++ = BPF_JMP_IMM(BPF_JEQ, ret, 0, 1);
	#ifdef CONFIG_HIVE
	if (map->is_aggregated)
		*insn++ = BPF_LDX_MEM(BPF_DW, ret, ret,
 				offsetof(struct htab_elem, key) +
 				round_up(map->key_size, 8));
	else {
		*insn++ = BPF_ALU64_IMM(BPF_ADD, ret, 
				offsetof(struct htab_elem, key) +
				roundup(map->key_size, 8));
	}
	#else
	*insn++ = BPF_ALU64_IMM(BPF_ADD, ret,
				offsetof(struct htab_elem, key) +
				round_up(map->key_size, 8));
	#endif
	return insn - insn_buf;
}
