static void put_cred_rcu(struct rcu_head *rcu)
{
	#ifdef CONFIG_CREDP
	struct cred *cred = *(struct cred **)(rcu + 1);
	#else
	struct cred *cred = container_of(rcu, struct cred, rcu);
	#endif

	kdebug("put_cred_rcu(%p)", cred);

	if (atomic_long_read(&cred->usage) != 0)
		panic("CRED: put_cred_rcu() sees %p with usage %ld\n",
		      cred, atomic_long_read(&cred->usage));

	security_cred_free(cred);
	key_put(cred->session_keyring);
	key_put(cred->process_keyring);
	key_put(cred->thread_keyring);
	key_put(cred->request_key_auth);
	if (cred->group_info)
		put_group_info(cred->group_info);
	free_uid(cred->user);
	if (cred->ucounts)
		put_ucounts(cred->ucounts);
	put_user_ns(cred->user_ns);
	#ifdef CONFIG_CREDP
	kmem_cache_free(rcu_jar, (struct rcu_head *)(cred->rcu.func));
	#endif
	kmem_cache_free(cred_jar, cred);
}