static void __init pud_clear_tests(struct pgtable_debug_args *args)
{
	pud_t pud = READ_ONCE(*args->pudp);

	if (mm_pmd_folded(args->mm))
		return;

	pr_debug("Validating PUD clear\n");
	pud = __pud(pud_val(pud) | RANDOM_ORVALUE);
	#ifdef CONFIG_PTP
	set_pud(args->pudp, pud);
	#else
	WRITE_ONCE(*args->pudp, pud);
	#endif
	pud_clear(args->pudp);
	pud = READ_ONCE(*args->pudp);
	WARN_ON(!pud_none(pud));
}