static void __init p4d_clear_tests(struct pgtable_debug_args *args)
{
	p4d_t p4d = READ_ONCE(*args->p4dp);

	if (mm_pud_folded(args->mm))
		return;

	pr_debug("Validating P4D clear\n");
	p4d = __p4d(p4d_val(p4d) | RANDOM_ORVALUE);
	#ifdef CONFIG_PTP
	set_p4d(args->p4dp, p4d);
	#else
	WRITE_ONCE(*args->p4dp, p4d);
	#endif
	p4d_clear(args->p4dp);
	p4d = READ_ONCE(*args->p4dp);
	WARN_ON(!p4d_none(p4d));
}