static void __init pgd_clear_tests(struct pgtable_debug_args *args)
{
	pgd_t pgd = READ_ONCE(*(args->pgdp));

	if (mm_p4d_folded(args->mm))
		return;

	pr_debug("Validating PGD clear\n");
	pgd = __pgd(pgd_val(pgd) | RANDOM_ORVALUE);
	#ifdef CONFIG_PTP
	set_pgd(args->pgdp, pgd);
	#else
	WRITE_ONCE(*args->pgdp, pgd);
	#endif
	pgd_clear(args->pgdp);
	pgd = READ_ONCE(*args->pgdp);
	WARN_ON(!pgd_none(pgd));
}