static inline bool slab_want_init_on_alloc(gfp_t flags, struct kmem_cache *c)
{
	#ifdef CONFIG_IEE
	if(c == iee_stack_jar)
		return false;
	#endif
	#ifdef CONFIG_PTP
	if(c == pgtable_jar)
		return false;
	#endif
	if (static_branch_unlikely(&init_on_alloc)) {
		if (c->ctor)
			return false;
		if (c->flags & (SLAB_TYPESAFE_BY_RCU | SLAB_POISON))
			return flags & __GFP_ZERO;
		return true;
	}
	return flags & __GFP_ZERO;
}
