static void free_slab(struct kmem_cache *s, struct slab *slab)
{
	if (kmem_cache_debug_flags(s, SLAB_CONSISTENCY_CHECKS)) {
		void *p;

		slab_pad_check(s, slab);
		for_each_object(p, s, slab_address(slab), slab->objects)
			check_object(s, slab, p, SLUB_RED_INACTIVE);
	}

    #ifdef CONFIG_PTP
	int order = compound_order(page);
	if(s == pgtable_jar)
	{
		int i;
		for(i = 1; i < (0x1 << order); i++)
		{
			kmem_cache_free(pgtable_page_jar, (page+i)->slab_cache);
			(page+i)->slab_cache = s;
		}
	}
	#endif

	if (unlikely(s->flags & SLAB_TYPESAFE_BY_RCU))
		call_rcu(&slab->rcu_head, rcu_free_slab);
	else
		__free_slab(s, slab);
}