static inline int bprm_caps_from_vfs_caps(struct cpu_vfs_cap_data *caps,
					  struct linux_binprm *bprm,
					  bool *effective,
					  bool *has_fcap)
{
	struct cred *new = bprm->cred;
	int ret = 0;

	if (caps->magic_etc & VFS_CAP_FLAGS_EFFECTIVE)
		*effective = true;

	if (caps->magic_etc & VFS_CAP_REVISION_MASK)
		*has_fcap = true;

	/*
	 * pP' = (X & fP) | (pI & fI)
	 * The addition of pA' is handled later.
	 */
	#ifdef CONFIG_CREDP
	kernel_cap_t temp = new->cap_permitted;
	temp.val = (new->cap_bset.val & caps->permitted.val) |
		(new->cap_inheritable.val & caps->inheritable.val);
	iee_set_cred_cap_permitted(new,temp);
	#else
	new->cap_permitted.val =
		(new->cap_bset.val & caps->permitted.val) |
		(new->cap_inheritable.val & caps->inheritable.val);
	#endif

	if (caps->permitted.val & ~new->cap_permitted.val)
		/* insufficient to execute correctly */
		ret = -EPERM;

	/*
	 * For legacy apps, with no internal support for recognizing they
	 * do not have enough capabilities, we return an error if they are
	 * missing some "forced" (aka file-permitted) capabilities.
	 */
	return *effective ? ret : 0;
}