# MigGPT Code Project

The benchmark is located in the `data_16k` directory.

## Environment Setup
To configure the environment, use the following commands:
```bash
conda create -n miggpt python=3.9
conda activate miggpt
pip install codebleu distance openai
```

## Task Migration Using Vanilla LLMs
1. Execute the script for generating new blocks:
   ```bash
   python get_new_block_vanilla.py
   ```
2. Execute the migration script:
   ```bash
   python mig_vanilla.py
   ```

## Task Migration Using MigGPT
1. Execute the script for generating new blocks with MigGPT:
   ```bash
   python get_new_block_miggpt.py
   ```
2. Execute the migration script with MigGPT:
   ```bash
   python mig_miggpt.py
   ```

## Metrics
1. To calculate the Best Match, run:
   ```bash
   python metric.py --method vanilla
   ```
2. To calculate the Semantic Match, use:
   ```bash
   python metric_codebleu.py --method vanilla
   ```