static inline void local_daif_inherit(struct pt_regs *regs)
{
	unsigned long flags = regs->pstate & DAIF_MASK;

	if (interrupts_enabled(regs))
		trace_hardirqs_on();

	if (system_uses_irq_prio_masking())
		gic_write_pmr(regs->pmr_save);

	/*
	 * We can't use local_daif_restore(regs->pstate) here as
	 * system_has_prio_mask_debugging() won't restore the I bit if it can
	 * use the pmr instead.
	 */
	#ifdef CONFIG_IEE
		iee_si_write_daif(flags);
	#else
	write_sysreg(flags, daif);
	#endif

	/* The ALLINT field is at the same position in pstate and ALLINT */
	if (system_uses_nmi()) {
		if (regs->pstate & ALLINT_ALLINT)
			_allint_set();
		else
			_allint_clear();
	}
}