static inline void cpu_set_reserved_ttbr0_nosync(void)
{
	unsigned long ttbr = phys_to_ttbr(__pa_symbol(reserved_pg_dir));

#ifdef CONFIG_IEE
	ttbr |= FIELD_PREP(TTBR_ASID_MASK, 1);
    iee_rwx_gate_entry(IEE_WRITE_ttbr0_el1, ttbr);
#else
	write_sysreg(ttbr, ttbr0_el1);
#endif
}

static inline void cpu_set_reserved_ttbr0(void)
{
	cpu_set_reserved_ttbr0_nosync();
	isb();
}