static inline void __cpu_set_tcr_t0sz(unsigned long t0sz)
{
	unsigned long tcr = read_sysreg(tcr_el1);

	if ((tcr & TCR_T0SZ_MASK) >> TCR_T0SZ_OFFSET == t0sz)
		return;

	tcr &= ~TCR_T0SZ_MASK;
	tcr |= t0sz << TCR_T0SZ_OFFSET;
#ifdef CONFIG_IEE
    iee_rwx_gate_entry(IEE_WRITE_tcr_el1, tcr);
#else
	write_sysreg(tcr, tcr_el1);
#endif
	isb();
}