static inline pte_t __ptep_get_and_clear(struct mm_struct *mm,
				       unsigned long address, pte_t *ptep)
{
	#ifdef CONFIG_PTP
	pteval_t pteval= iee_set_xchg_relaxed((pte_t *)&pte_val(*ptep), (pteval_t)0);
	pte_t pte = __pte(pteval);
	#else
	pte_t pte = __pte(xchg_relaxed(&pte_val(*ptep), 0));
	#endif
	page_table_check_pte_clear(mm, pte);

	return pte;
}

static inline pte_t ptep_get_and_clear(struct mm_struct *mm,
				unsigned long addr, pte_t *ptep)
{
	contpte_try_unfold(mm, addr, ptep, __ptep_get(ptep));
	return __ptep_get_and_clear(mm, addr, ptep);
}