#define pud_leaf(pud)		(pud_present(pud) && !pud_table(pud))
#define pud_valid(pud)		pte_valid(pud_pte(pud))
#define pud_user(pud)		pte_user(pud_pte(pud))
#define pud_user_exec(pud)	pte_user_exec(pud_pte(pud))

#ifdef CONFIG_PTP
extern void iee_set_fixmap_pud_pre_init(pud_t *pudp, pud_t pud);
#endif

#ifdef CONFIG_IEE
extern void set_pud(pud_t *pudp, pud_t pud);
#else
static inline void set_pud(pud_t *pudp, pud_t pud)
{
#ifdef __PAGETABLE_PUD_FOLDED
	if (in_swapper_pgdir(pudp)) {
		set_swapper_pgd((pgd_t *)pudp, __pgd(pud_val(pud)));
		return;
	}
#endif /* __PAGETABLE_PUD_FOLDED */
#ifdef CONFIG_KOI
    pudval_t val = pud_val(pud);
    if (pud_valid(pud) && !(val & PUD_TABLE_BIT)) {
        // There is no PUD_SEC_NG, so we use PMD_SECT_NG instead.
        pud = __pud(val | PMD_SECT_NG);
    }
#endif
	WRITE_ONCE(*pudp, pud);
	if (pud_valid(pud)) {
		dsb(ishst);
		isb();
	}
}
#endif