static void __init setup_system_capabilities(void)
{
	/*
	 * We have finalised the system-wide safe feature
	 * registers, finalise the capabilities that depend
	 * on it. Also enable all the available capabilities,
	 * that are not enabled already.
	 */
	update_cpu_capabilities(SCOPE_SYSTEM);
	enable_cpu_capabilities(SCOPE_ALL & ~SCOPE_BOOT_CPU);
}

#ifdef CONFIG_IEE

static void iee_si_test_end(void)
{
    pr_info("IEE: testing iee_exec_entry sctlr...\n");
    iee_rwx_gate_entry(IEE_WRITE_SCTLR, read_sysreg(sctlr_el1)& ~SCTLR_ELx_M);
    pr_info("IEE: testing iee_exec_entry ttbr0_el1...\n");
    iee_rwx_gate_entry(IEE_WRITE_TTBR0, read_sysreg(ttbr0_el1));
    pr_info("IEE: testing iee_exec_entry vbar...\n");
    iee_rwx_gate_entry(IEE_WRITE_VBAR, read_sysreg(vbar_el1));
    pr_info("IEE: testing iee_exec_entry tcr...\n");
    iee_rwx_gate_entry(IEE_WRITE_TCR, read_sysreg(tcr_el1));
	#ifdef CONFIG_KOI
    write_sysreg(read_sysreg(ttbr0_el1)+0x3000000000000, ttbr0_el1);
	pr_info("IEE: current TTBR1_EL1:%llx, TTBR0:%llx\n", read_sysreg(ttbr1_el1), read_sysreg(ttbr0_el1));
	pr_info("IEE: testing iee_exec_entry switch to koi...\n");
    iee_rwx_gate_entry(IEE_SWITCH_TO_KOI, phys_to_ttbr(__pa_symbol(swapper_pg_dir)));
	pr_info("IEE: current TTBR1_EL1:%llx, TTBR0:%llx\n", read_sysreg(ttbr1_el1), read_sysreg(ttbr0_el1));
	pr_info("IEE: testing iee_exec_entry switch to kernel...\n");
    iee_rwx_gate_entry(IEE_SWITCH_TO_KERNEL);
	#endif
}

/* Finish iee rwx gate initializations. */
static void __init iee_si_init_done(void)
{
	// Prepare data for iee rwx gate
	iee_si_prepare_data();
    // All initialization is done. Do some simple tests.
    iee_si_test_end();
}
#endif

void __init setup_cpu_features(void)
{
	u32 cwg;

	setup_system_capabilities();
	setup_elf_hwcaps(arm64_elf_hwcaps);

	if (system_supports_32bit_el0()) {
		setup_elf_hwcaps(a32_elf_hwcaps);
		elf_hwcap_fixup();
	}

	if (system_uses_ttbr0_pan())
		pr_info("emulated: Privileged Access Never (PAN) using TTBR0_EL1 switching\n");

	sve_setup();
	sme_setup();
	minsigstksz_setup();

	/* Advertise that we have computed the system capabilities */
	finalize_system_capabilities();

	/*
	 * Check for sane CTR_EL0.CWG value.
	 */
	cwg = cache_type_cwg();
	if (!cwg)
		pr_warn("No Cache Writeback Granule information, assuming %d\n",
			ARCH_DMA_MINALIGN);
    
    #ifdef CONFIG_IEE
	iee_si_init_done();
	#endif
}