static int asids_init(void)
{
	#if defined(CONFIG_IEE) || defined(CONFIG_KOI)
	unsigned int len;
	#endif

	asid_bits = get_cpu_asid_bits();
	atomic64_set(&asid_generation, ASID_FIRST_VERSION);
	asid_map = kcalloc(BITS_TO_LONGS(NUM_USER_ASIDS), sizeof(*asid_map),
			   GFP_KERNEL);
	if (!asid_map)
		panic("Failed to allocate bitmap for %lu ASIDs\n",
		      NUM_USER_ASIDS);

	pinned_asid_map = kcalloc(BITS_TO_LONGS(NUM_USER_ASIDS),
				  sizeof(*pinned_asid_map), GFP_KERNEL);
	nr_pinned_asids = 0;

    #if defined(CONFIG_IEE) || defined(CONFIG_KOI)
        len = BITS_TO_LONGS(NUM_USER_ASIDS) * sizeof(unsigned long);
    	memset(asid_map, 0xaa, len);
		__set_bit(INIT_ASID, asid_map);
    #else 
            /*
	         * We cannot call set_reserved_asid_bits() here because CPU
	         * caps are not finalized yet, so it is safer to assume KPTI
	         * and reserve kernel ASID's from beginning.
	         */
	        if (IS_ENABLED(CONFIG_UNMAP_KERNEL_AT_EL0))
		        set_kpti_asid_bits(asid_map);
    #endif

	return 0;
}