static void die_kernel_fault(const char *msg, unsigned long addr,
			     unsigned long esr, struct pt_regs *regs)
{
	bust_spinlocks(1);

    #ifdef CONFIG_HIVE
	if (bpf_sfi_hook_kernel_fault(addr)) {
		pr_err("detected bpf sfi guard page %lx access\n", addr);
		regs->pc += 4;
		return;
	}
	#endif

	pr_alert("Unable to handle kernel %s at virtual address %016lx\n", msg,
		 addr);

	kasan_non_canonical_hook(addr);

	mem_abort_decode(esr);

	show_pte(addr);
	die("Oops", regs, esr);
	bust_spinlocks(0);
	make_task_dead(SIGKILL);
}