static void __init pmd_clear_tests(struct pgtable_debug_args *args)
{
	pmd_t pmd = READ_ONCE(*args->pmdp);

	pr_debug("Validating PMD clear\n");
	pmd = __pmd(pmd_val(pmd) | RANDOM_ORVALUE);
	#ifdef CONFIG_PTP
	set_pmd(args->pmdp, pmd);
	#else
	WRITE_ONCE(*args->pmdp, pmd);
	#endif
	pmd_clear(args->pmdp);
	pmd = READ_ONCE(*args->pmdp);
	WARN_ON(!pmd_none(pmd));
}