int slab_unmergeable(struct kmem_cache *s)
{
	if (slab_nomerge || (s->flags & SLAB_NEVER_MERGE))
		return 1;

	if (s->ctor)
		return 1;

	#ifdef CONFIG_IEE
	if(strcmp(s->name, "iee_stack_jar") == 0)
		return 1;
	#endif
	#ifdef CONFIG_PTP
	if(strcmp(s->name, "pgtable_jar") == 0)
		return 1;
	#endif

#ifdef CONFIG_HARDENED_USERCOPY
	if (s->usersize)
		return 1;
#endif

	/*
	 * We may have set a slab to be unmergeable during bootstrap.
	 */
	if (s->refcount < 0)
		return 1;

	return 0;
}