static inline bool shuffle_freelist(struct kmem_cache *s, struct slab *slab)
{
	#ifdef CONFIG_IEE
	void *start;
	unsigned long freelist_count;
	freelist_count = oo_objects(s->oo);
	start = fixup_red_left(s, page_address(slab));
	if(s == task_struct_cachep)
	{
		int i;
		void *pstack;
		void *obj;
		for(i = 0; i < freelist_count; i++)
		{
			pstack = get_iee_stack();
			obj = start + s->size * i;
			iee_init_token((struct task_struct *)obj, pstack + PAGE_SIZE * 4, (void *)__get_free_pages(GFP_KERNEL | __GFP_ZERO, 0));
		}
	}
	#endif
	return false;
}