static inline bool cpu_smt_allowed(unsigned int cpu)
{
	if (topology_is_primary_thread(cpu))
		return true;

	/*
	 * If the CPU is not a 'primary' thread and the booted_once bit is
	 * set then the processor has SMT support. Store this information
	 * for the late check of SMT support in cpu_smt_check_topology().
	 */
	if (per_cpu(cpuhp_state, cpu).booted_once)
		cpu_smt_available = true;

	if (cpu_smt_control == CPU_SMT_ENABLED)
		return true;

	/*
	 * On x86 it's required to boot all logical CPUs at least once so
	 * that the init code can get a chance to set CR4.MCE on each
	 * CPU. Otherwise, a broadacasted MCE observing CR4.MCE=0b on any
	 * core will shutdown the machine.
	 */
	return !per_cpu(cpuhp_state, cpu).booted_once;
}