import os
import random
import shutil

train_sample_percent = 0.1
val_sample_percent = 0.025

for root, dirs, files in os.walk('/export/data/lwangcg/ILSVRC2012/train'):
    NO_image = len(files)
    if NO_image <= 0: continue
    print(NO_image)
    picked_train_images = random.sample(files, int(NO_image * train_sample_percent))
    target_train_dir = '/export/data/lwangcg/ILSVRC2012/SampledTrainDataset/train/'+root.split('/')[-1]
    target_val_dir = '/export/data/lwangcg/ILSVRC2012/SampledTrainDataset/val/'+root.split('/')[-1]
    no_train_images = [x for x in files if x not in picked_train_images]
    picked_val_images = random.sample(no_train_images, int(NO_image * val_sample_percent))
    os.mkdir(target_train_dir)
    for picked_train_image in picked_train_images:
        shutil.copyfile(root+'/'+picked_train_image, target_train_dir+'/'+picked_train_image.split('.')[0]+'.jpeg')
    os.mkdir(target_val_dir)
    for picked_val_image in picked_val_images:
        shutil.copyfile(root+'/'+picked_val_image, target_val_dir+'/'+picked_val_image.split('.')[0]+'.jpeg')


# for root, dirs, files in os.walk('/export/data/lwangcg/ILSVRC2012/val'):
#     NO_image = len(files)
#     print(NO_image)
#     picked_images = random.sample(files, int(NO_image*val_sample_percent))
#     target_dir = '/export/data/lwangcg/ILSVRC2012/SampledDataset/val/'+root.split('/')[-1]
#     os.mkdir(target_dir)
#     for picked_image in picked_images:
#         shutil.copyfile(root+'/'+picked_image, target_dir+'/'+picked_image)