# Unlearning Isn’t Deletion: Investigating Reversibility of Machine Unlearning in LLMs

This is the implementation for the paper **Unlearning Isn’t Deletion: Investigating Reversibility of Machine Unlearning in LLMs**.

In this work, we present the first systematic analysis of reversibility in LLM unlearning, with a focus on both single-shot and continual unlearning settings.

In order to reproduce our results, take the following steps:

### 1. Create conda environment and install requirements
```
conda create -n unlearning python=3.10.15
conda activate unlearning
conda install pytorch==2.2.0 pytorch-cuda=11.8 -c pytorch -c nvidia
conda install -c "nvidia/label/cuda-11.8.0" cuda-toolkit
pip install -r requirements.txt
pip install flash-attn==2.5.3 --no-build-isolation
python -m spacy download en_core_web_sm
```

### 2. Unlearning
#request_num, N, model_name, lr, data_type, unlearning_algorithm and test_data_type are variable.
```
export CUDA_VISIBLE_DEVICES=0,1

#Single unlearning
python main_unlearning.py --N 100 --max_length 128 --request_num 1 --lr 5e-6 --model_name 01-ai/Yi-6B   #N means the data volunms of each unlearning request simple task

#Continual unlearning
python main_unlearning.py --N 1 --max_length 128 --request_num 100 --lr 5e-6 --model_name 01-ai/Yi-6B   #simple task
python main_unlearning_math.py --N 5000 --max_length 128 --request_num 6 --lr 3e-5 --model_name Qwen/Qwen2.5-7B   #complex task
```
### 3. Relearning
```
export CUDA_VISIBLE_DEVICES=0,1
#Single learning
python main_relearning.py --N 100 --max_length 128 --request_num 1 --type "all" --lr 5e-6 --model_name 01-ai/Yi-6B --data_type forget_set  #simple task 

##Continual learning
python main_relearning.py --N 1 --max_length 128 --request_num 100 --type "all" --lr 5e-6 --model_name 01-ai/Yi-6B --data_type forget_set  #simple task
python main_relearning_math.py --N 5000 --max_length 128 --request_num 6 --lr 3e-5 --model_name Qwen/Qwen2.5-7B #complex task
```
### 4. Evaluation 
```
#Acc and Ppl
python evaluations.py --lr 5e-6 --model_name 01-ai/Yi-6B --process unlearn --unlearning_algorithm GA --type Text --phase N1_Request100  
#MIA
python MIA.py --lr 5e-6 --model_name 01-ai/Yi-6B --unlearning_algorithm GA --type Text --phase N100_Request1
```
#For Commonsenseqa, GSM8k, and Math, we use opencompass to evaluate(https://github.com/open-compass/opencompass.git).
### 5. Feature analysis
```
export CUDA_VISIBLE_DEVICES=3
python analyse_PCA_Sim.py --lr 5e-6 --model_name 01-ai/Yi-6B --unlearning_algorithm GA --type Text --phase N1_Request100 --relearn_data_type forget_set --test_data_type forget_set 
python analyse_PCA_Shift.py --lr 5e-6 --model_name 01-ai/Yi-6B --unlearning_algorithm GA --type Text --phase N1_Request100 --relearn_data_type forget_set --test_data_type forget_set
python analyse_CKA.py --lr 5e-6 --model_name 01-ai/Yi-6B --unlearning_algorithm GA --type Text --phase N1_Request100 --relearn_data_type forget_set --test_data_type forget_set
python analyse_Fisher.py --lr 5e-6 --model_name 01-ai/Yi-6B --unlearning_algorithm GA --type Text --phase N1_Request100 --relearn_data_type forget_set --test_data_type forget_set
```

