% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_recommendations.R
\name{evaluate_recommendations}
\alias{evaluate_recommendations}
\title{Evaluate Recommender Output}
\usage{
evaluate_recommendations(recs, perfs)
}
\arguments{
\item{recs}{A character vector. Output of any of the `predict()` functions output by any `recommender` object.}

\item{perfs}{A data frame corresponding to one row per dataset and one column per configuration, with performance values on each cell.}
}
\value{
A data frame with four columns: `recommendation` (the recommended configuration), `performance` (the performance value of the selected option), `performance_max` (the maximum possible performance for that dataset), and `percentile` (the percentile of performance in which the recommendation falls in).
}
\description{
This function takes the output of any recommender and evaluates the percentile of performance in which the output recommendations fall.
}
\examples{

dat <- get_data()
gb <- recommender('global_best')
gb <- gb \%>\% fit(dat$train$performance, dat$train$metafeatures, median = T)
gb \%>\% predict(dat$test$metafeatures)
recs <- gb \%>\% predict(dat$test$metafeatures)
perfs <- dat$test$performance
evaluate_recommendations(recs, perfs)
}
