% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_cfact.R
\name{fit.cfact}
\alias{fit.cfact}
\title{Fit cFact model recommender}
\usage{
fit.cfact(object, train_performance, train_metafeatures, n_factors = 5, ...)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}

\item{n_factors}{Number of factors to use for the SVD decomposition.}

\item{...}{Extra parameters to pass to the Random Forest model.}
}
\value{
A list of lists containing three elements each: 1.`models`, one Random Forest per `n_factors`, 2. `dv`, the matrix multiplication of `DV'`,
used internally for prediction and 3. `configurations`, the names of the models, used for prediction.
}
\description{
Model recommender training. This model separates the configurations using clustering and then approximates each clusters' performance matrix using SVD and uses Random Forest to train regression models to get U from metafeatures.
}
\examples{

dat <- get_data(train_test_split = T)
cfact <- recommender('cfact')
cfact <- cfact \%>\% fit(dat$train$performance, dat$train$metafeatures, 5)
cfact \%>\% predict(dat$test$metafeatures)
}
