% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_nearest_neighbor.R
\name{fit.nearest_neighbor}
\alias{fit.nearest_neighbor}
\title{Fit Nearest Neighbor model recommender}
\usage{
fit.nearest_neighbor(
  object,
  train_performance,
  train_metafeatures,
  scale_data = TRUE,
  ...
)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}

\item{scale_data}{Logical. Whether to calculate the zscore, center and scale the meta-feature space. Defaults to `TRUE`.}
}
\value{
A list containing one element: `recommendation`, the selected configuration.
}
\description{
Baseline recommender: selects the best configuration of the closest dataset in the metafeature space.
}
\examples{

dat <- get_data(train_test_split = TRUE)
nn <- recommender('nearest_neighbor')
nn <- nn \%>\% fit(dat$train$performance, dat$train$metafeatures)
nn \%>\% predict(dat$test$metafeatures)
}
