% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_regression.R
\name{fit.regression}
\alias{fit.regression}
\title{Fit a regression model recommender}
\usage{
fit.regression(object, train_performance, train_metafeatures, ...)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}

\item{...}{Extra parameters to pass to the Random Forest model.}
}
\value{
A list containing two elements: 1.`models`, one Random Forest per `n_factors`, 2. `configurations`, the names of the models, used for prediction.
}
\description{
Model recommender training. This model trains Random Forest regression models directly from the metafeatures to the performance matrix.
}
\examples{

dat <- get_sample_data()
reg <- recommender('regression_rf')
reg <- reg \%>\% fit(dat$train$performance, dat$train$metafeatures, nrounds = 20)
reg \%>\% predict(dat$test$metafeatures)
}
