% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_uRegression2.R
\name{fit.u_regression2}
\alias{fit.u_regression2}
\title{Fit a uregression model recommender with 2 vectors by default}
\usage{
fit.u_regression2(
  object,
  train_performance,
  train_metafeatures,
  n_factors = 2,
  ...
)
}
\arguments{
\item{train_performance}{A data frame or matrix corresponding one row per dataset and one column per configuration, with performance values on each cell.}

\item{train_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}

\item{n_factors}{Number of factors to use for the SVD decomposition. Defaults to 2.}

\item{...}{Extra parameters to pass to the Random Forest model.}
}
\value{
A list containing three elements: 1.`models`, one Random Forest per `n_factors`, 2. `dv`, the matrix multiplication of `DV'`,
used internally for prediction and 3. `configurations`, the names of the models, used for prediction.
}
\description{
Model recommender training. This model approximates the performance matrix using SVD and uses Random Forest to train regression models to get U from metafeatures.
}
\examples{

dat <- get_data()
ureg <- recommender('u_regression_rf')
ureg <- ureg \%>\% fit(dat$train$performance, dat$train$metafeatures, 5)
ureg \%>\% predict(dat$test$metafeatures)
}
