% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_cfact.R
\name{predict.cfact}
\alias{predict.cfact}
\title{Recommend models for new datasets using cFact}
\usage{
predict.cfact(object, test_metafeatures)
}
\arguments{
\item{object}{Object obtained from `fit.cfact()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`.
}
\examples{

dat <- get_data(train_test_split = T)
cfact <- recommender('cfact')
cfact <- cfact \%>\% fit(dat$train$performance, dat$train$metafeatures, 5)
cfact \%>\% predict(dat$test$metafeatures)
}
