% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_nearest_neighbor.R
\name{predict.nearest_neighbor}
\alias{predict.nearest_neighbor}
\title{Recommend models for new datasets using Nearest Neighbor}
\usage{
predict.nearest_neighbor(object, test_metafeatures)
}
\arguments{
\item{object}{Object obtained from `fit.nearest_neighbor()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`. Each dataset is compared against the training
metafeatures and their nearest neighbor is obtained. The configuration with maximum performance in the nearest neighbor is recommended.
}
\examples{

dat <- get_data(train_test_split = TRUE)
nn <- recommender('nearest_neighbor')
nn <- nn \%>\% fit(dat$train$performance, dat$train$metafeatures)
nn \%>\% predict(dat$test$metafeatures)
}
