% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommender_orthus.R
\name{predict.orthus}
\alias{predict.orthus}
\title{Recommend models for new datasets using Orthus}
\usage{
predict.orthus(object, test_metafeatures)
}
\arguments{
\item{object}{Object obtained from `fit.orthus()`.}

\item{test_metafeatures}{A a data frame containing the metafeatures of each dataset as columns.}
}
\value{
A character string corresponding to the recommended model per row on `test_metafeatures`.
}
\description{
Model recommendation. Issues a single model recommendation per row in `test_metafeatures`.
}
\examples{

dat <- get_data(train_test_split = T)
orthus <- recommender('orthus')
orthus <- orthus \%>\% fit(dat$train$performance, dat$train$metafeatures)
orthus \%>\% predict(dat$test$metafeatures)
}
